package org.umk.opengl;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;

class RendererGL implements GLSurfaceView.Renderer {
	private final Context kontekst;
	
	// aktor
	private final SzescianGL szescian = new SzescianGL();
	
	// animacja
	private long czasStartu;
	//private long czasStartuKlatki;
	//private long iloscRamek;
	
	RendererGL(Context kontekst) {
		this.kontekst = kontekst;
	}
	
	public void onSurfaceCreated(GL10 gl, EGLConfig konfig) {
		gl.glEnable(GL10.GL_DEPTH_TEST);
		gl.glDepthFunc(GL10.GL_LEQUAL);
		gl.glEnableClientState(GL10.GL_VERTEX_ARRAY);
		
		// poniej owietlenie
		float[] oswietlenieDookolne = new float[] { 0.2f, 0.2f, 0.2f, 1 };
		float[] oswietlenieRozproszone = new float[] { 1, 1, 1, 1 };
		float[] pozostaleZrodlaSwiatla = new float[] { 1, 1, 1, 1 };
		gl.glEnable(GL10.GL_LIGHTING);
		gl.glEnable(GL10.GL_LIGHT0);
		gl.glLightfv(GL10.GL_LIGHT0, GL10.GL_AMBIENT, oswietlenieDookolne, 0);
		gl.glLightfv(GL10.GL_LIGHT0, GL10.GL_DIFFUSE, oswietlenieRozproszone, 0);
		gl.glLightfv(GL10.GL_LIGHT0, GL10.GL_POSITION, pozostaleZrodlaSwiatla, 0);
		
		// symulacja materiau
		float[] materialDookolne = new float[] { 1, 1, 1, 1 };
		float[] materialRozproszone = new float[] { 1, 1, 1, 1 };
		gl.glMaterialfv(GL10.GL_FRONT_AND_BACK, GL10.GL_AMBIENT, materialDookolne, 0);
		gl.glMaterialfv(GL10.GL_FRONT_AND_BACK, GL10.GL_DIFFUSE, materialRozproszone, 0);
		
		// animacja
		czasStartu = System.currentTimeMillis();
		//czasStartuKlatki = czasStartu;
		//iloscRamek = 0;
		
		// tekstura
		gl.glEnableClientState(GL10.GL_TEXTURE_COORD_ARRAY);
		gl.glEnable(GL10.GL_TEXTURE_2D);
		
		// przezroczysto
		boolean przezroczystosc = true;
		if(przezroczystosc) {
			gl.glDisable(GL10.GL_DEPTH_TEST);
			gl.glEnable(GL10.GL_BLEND);
			gl.glBlendFunc(GL10.GL_SRC_ALPHA, GL10.GL_ONE);
		}
		
		SzescianGL.wczytajTeksture(gl, kontekst, R.drawable.android);
	}
	
	public void onSurfaceChanged(GL10 gl, int szerokosc, int wysokosc) {
		gl.glViewport(0, 0, szerokosc, wysokosc);
		gl.glMatrixMode(GL10.GL_PROJECTION);
		gl.glLoadIdentity();
		
		float proporcje = (float) szerokosc / wysokosc;
		GLU.gluPerspective(gl, 45.0f, proporcje, 1, 100f);
	}
	
	public void onDrawFrame(GL10 gl) {
		gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);
		gl.glMatrixMode(GL10.GL_MODELVIEW);
		gl.glLoadIdentity();
		gl.glTranslatef(0, 0, -3.0f);
		
		// animacja ->
		long szacowany = System.currentTimeMillis() - czasStartu;
		gl.glRotatef(szacowany * (30f / 1000f), 0, 1, 0);
		gl.glRotatef(szacowany * (15f / 1000f), 1, 0, 0);
		// <- animacja
		
		szescian.rysuj(gl);
	}
}
